/*****************************************************************************
| FILE:         inc_fi_main.h
| PROJECT:      G3g
| SW-COMPONENT: ---
|------------------------------------------------------------------------------
| DESCRIPTION:  Message dispatcher instance. Will provide all required functionality
|
|------------------------------------------------------------------------------
| COPYRIGHT:    (c) 2013 Robert Bosch GmbH
| HISTORY:
| Date      | Modification               | Author
| 08.06.13  | Initial revision           | Ranjit Katuri
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

#ifndef INCLUDE_INC_FI_MAIN_H_IF
#define INCLUDE_INC_FI_MAIN_H_IF

#include <map>
#include <pthread.h>

#include "inc_fi_base.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "common_fi_if.h"

class inc_fi_handler;

class inc_fi_main : public inc_fi_base
{
private:
  //Explicit private
  inc_fi_main();
  //Internal map for dispatching, cant use a map with references :(
  std::map<uint16_t, inc_fi_handler*>  m_dispatchtable;
  /**
  * Mutex to handle the dispatch table
  */
  pthread_mutex_t              m_dpmutex;
  /**
  * Over riding pvf from baseclass
  */
  virtual void vOnNewMessage (amt_tclBaseMessage* poMessage);
  /**
  * Over riding pvf from baseclass
  */
  virtual void vOnServiceState
    (
      uint16_t u16ServiceId,
      uint16_t u16ServerId,
      uint16_t u16RegisterId,
      uint8_t u8ServiceState,
      uint16_t u16SubId  );
  /**
  * Pointer to self
  */
  static inc_fi_main* m_ptrself;

public:
  //Destructor
  virtual ~inc_fi_main();

  static inc_fi_main* poGetInstance();

  /**
  * Helper function to register a inc fi handler
  */
  bool  bRegisterHandler(uint16_t srvid, inc_fi_handler* ptrhandler);
  /**
  * Helper function to unregister a inc fi handler
  */
  bool bUnRegisterHandler(uint16_t srvid);
  /**
  * Helper function to check if a service is available
  */
  bool bIsServiceAvailable(uint16_t srvid);
};

#endif

